package org.eclipse.swt.internal.carbon;

/*
 * Copyright (c) 2000, 2002 IBM Corp.  All rights reserved.
 * This file is made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */

import org.eclipse.swt.internal.Library;

public class OS extends OS2 {

	/* Load the SWT library. */
	static {
		Library.loadLibrary ("swt");
	}
	
	/** Constants */
	public static final int RGBDirect = 16;
	public static final int bold = 1;
	public static final int checkMark = 18;
	public static final int cmdKey = 1 << 8;
	public static final int controlKey = 1 << 12;
	public static final int diamondMark = 19;
	public static final int errControlIsNotEmbedder = -30590;
	public static final int errUnknownControl = -30584;
	public static final int eventLoopTimedOutErr = -9875;
	public static final int eventNotHandledErr = -9874;
	public static final int inContent = 3;
	public static final int inMenuBar = 1;
	public static final int inStructure = 15;
	public static final int italic = 2;
	public static final int kAEQuitApplication = ('q'<<24) + ('u'<<16) + ('i'<<8) + 't';
	public static final int kAlertCautionAlert = 2;
	public static final int kAlertNoteAlert = 1;
	public static final int kAlertPlainAlert = 3;
	public static final int kAlertStopAlert = 0;
	public static final int kAtSpecifiedOrigin = 0;
	public static final int kCFAllocatorDefault = 0;
	public static final int kCFURLPOSIXPathStyle = 0;
	public static final int kColorPickerDialogIsMoveable =  1;
	public static final int kColorPickerDialogIsModal = 2;
	public static final int kControlBehaviorToggles = 0x0100;
	public static final int kControlBevelButtonNormalBevelProc = 33;
	public static final int kControlCheckBoxAutoToggleProc = 371;
	public static final int kControlContentCIconHandle = 130;
	public static final int kControlContentMetaPart = -2;
	public static final int kControlDownButtonPart = 21;
	public static final int kControlEditTextCFStringTag = ('c'<<24) + ('f'<<16) + ('s'<<8) + 't';
	public static final int kControlEditTextSelectionTag = ('s'<<24) + ('e'<<16) + ('l'<<8) + 'e';
	public static final int kControlEntireControl = 0;
	public static final int kControlGetsFocusOnClick = 1 << 8;
	public static final int kControlGroupBoxTextTitleProc = 160;
	public static final int kControlHandlesTracking = 1 << 5;
	public static final int kControlIndicatorPart = 129;
	public static final int kControlPageDownPart = 23;
	public static final int kControlPageUpPart = 22;
	public static final int kControlPopupArrowEastProc = 192;
	public static final int kControlPopupButtonProc = 400;
	public static final int kControlProgressBarIndeterminateTag = ('i'<<24) + ('n'<<16) + ('d'<<8) + 'e';
	public static final int kControlProgressBarProc = 80;
	public static final int kControlPushButtonProc = 368;
	public static final int kControlRadioButtonAutoToggleProc = 372;
	public static final int kControlScrollBarLiveProc = 386;
	public static final int kControlSeparatorLineProc = 144;
	public static final int kControlSliderLiveFeedback = (1 << 0);
	public static final int kControlSliderNonDirectional = (1 << 3);
	public static final int kControlSliderProc = 48;
	public static final int kControlStructureMetaPart = -1;
	public static final int kControlSupportsEmbedding = 1 << 1;
	public static final int kControlSupportsFocus = 1 << 2;
	public static final int kControlTabContentRectTag = ('r'<<24) + ('e'<<16) + ('c'<<8) + 't';
	public static final int kControlTabInfoVersionOne = 1;
	public static final int kControlTabInfoTag = ('t'<<24) + ('a'<<16) + ('b'<<8) + 'i';
	public static final int kControlTabSmallProc = 129;
	public static final int kControlUpButtonPart = 20;
	public static final int kControlUserPaneDrawProcTag = ('d'<<24) + ('r'<<16) + ('a'<<8) + 'w';
	public static final int kControlUserPaneHitTestProcTag = ('h'<<24) + ('i'<<16) + ('t'<<8) + 't';
	public static final int kControlUserPaneProc = 256;
	public static final int kControlUserPaneTrackingProcTag = ('t'<<24) + ('r'<<16) + ('a'<<8) + 'k';
	public static final int kControlUseFontMask = 0x1;
	public static final int kControlUseSizeMask = 0x4;
	public static final int kControlUseFaceMask = 0x2;
	public static final int kDataBrowserCheckboxType = ('c'<<24) + ('h'<<16) + ('b'<<8) + 'x';
	public static final int kDataBrowserCmdTogglesSelection = 1 << 3;
	public static final int kDataBrowserContainerClosed = 10;
	public static final int kDataBrowserContainerClosing = 9;
	public static final int kDataBrowserContainerIsClosableProperty = 6;
	public static final int kDataBrowserContainerIsOpen = 1 << 1;
	public static final int kDataBrowserContainerIsOpenableProperty = 5;
	public static final int kDataBrowserContainerIsSortableProperty = 7;
	public static final int kDataBrowserContainerOpened = 8;
	public static final int kDataBrowserDefaultPropertyFlags = 0;
	public static final int kDataBrowserDragSelect = 1 << 0;
	public static final int kDataBrowserIconAndTextType = ('t'<<24) + ('i'<<16) + ('c'<<8) + 'n';
	public static final int kDataBrowserItemIsActiveProperty = 1;
	public static final int kDataBrowserItemIsContainerProperty = 4;
	public static final int kDataBrowserItemIsEditableProperty = 3;
	public static final int kDataBrowserItemIsSelectableProperty = 2;
	public static final int kDataBrowserItemIsSelected = 1 << 0;
	public static final int kDataBrowserItemNoProperty = 0;
	public static final int kDataBrowserItemParentContainerProperty = 11;
	public static final int kDataBrowserItemsAssign = 1;
	public static final int kDataBrowserItemsRemove = 3;
	public static final int kDataBrowserLatestCallbacks = 0;
	public static final int kDataBrowserListView = ('l'<<24) + ('s'<<16) + ('t'<<8) + 'v';
	public static final int kDataBrowserListViewLatestHeaderDesc = 0;
	public static final int kDataBrowserListViewSelectionColumn = 1 << OS.kDataBrowserViewSpecificFlagsOffset;
	public static final int kDataBrowserNeverEmptySelectionSet = 1 << 6;
	public static final int kDataBrowserNoItem = 0;
	public static final int kDataBrowserOrderIncreasing = 1;
	public static final int kDataBrowserPropertyEnclosingPart = 0;
	public static final int kDataBrowserPropertyIsMutable = 1 << 0;
	public static final int kDataBrowserSelectOnlyOne = 1 << 1;
	public static final int kDataBrowserTextType = ('t'<<24) + ('e'<<16) + ('x'<<8) + 't';
	public static final int kDataBrowserViewSpecificFlagsOffset = 16;
	public static final int kDocumentWindowClass = 6;
	public static final int kEventAppleEvent = 1;
	public static final int kEventAttributeUserEvent = 1 << 0;
	public static final int kEventClassAppleEvent = ('e'<<24) + ('p'<<16) + ('p'<<8) + 'c';
	public static final int kEventClassCommand = ('c'<<24) + ('m'<<16) + ('d'<<8) + 's';
	public static final int kEventClassControl = ('c'<<24) + ('n'<<16) + ('t'<<8) + 'l';
	public static final int kEventClassHIObject = ('h'<<24) + ('i'<<16) + ('o'<<8) + 'b';
	public static final int kEventClassKeyboard = ('k'<<24) + ('e'<<16) + ('y'<<8) + 'b';
	public static final int kEventClassMenu = ('m'<<24) + ('e'<<16) + ('n'<<8) + 'u';
	public static final int kEventClassMouse = ('m'<<24) + ('o'<<16) + ('u'<<8) + 's';
	public static final int kEventClassTextInput = ('t'<<24) + ('e'<<16) + ('x'<<8) + 't';
	public static final int kEventClassWindow = ('w'<<24) + ('i'<<16) + ('n'<<8) + 'd';
	public static final int kEventControlAddedSubControl = 152;
	public static final int kEventControlBoundsChanged = 154;
	public static final int kEventControlDraw = 4;
	public static final int kEventControlHit = 1;
	public static final int kEventControlRemovingSubControl = 153;
	public static final double kEventDurationForever = -1.0;
	public static final double kEventDurationNoWait = 0.0;
	public static final int kEventHIObjectConstruct = 1;
	public static final int kEventHIObjectDestruct = 3;
	public static final int kEventMenuClosed = 5;
	public static final int kEventMenuOpening = 4;
	public static final int kEventMenuPopulate = 9;
	public static final int kEventMouseButtonPrimary = 1;
	public static final int kEventMouseButtonSecondary = 2;
	public static final int kEventMouseButtonTertiary = 3;
	public static final int kEventMouseDown = 1;
	public static final int kEventMouseDragged = 6;
	public static final int kEventMouseMoved = 5;
	public static final int kEventMouseUp = 2;
	public static final int kEventMouseWheelMoved = 10;
	public static final int kEventParamAEEventClass = ('e'<<24) + ('v'<<16) + ('c'<<8) + 'l';
	public static final int kEventParamAEEventID = ('e'<<24) + ('v'<<16) + ('t'<<8) + 'i';
	public static final int kEventParamAttributes = ('a'<<24) + ('t'<<16) + ('t'<<8) + 'r';
	public static final int kEventParamCGContextRef= ('c'<<24) + ('n'<<16) + ('t'<<8) + 'x';
	public static final int kEventParamControlPart= ('c'<<24) + ('p'<<16) + ('r'<<8) + 't';
	public static final int kEventParamControlRef = ('c'<<24) + ('t'<<16) + ('r'<<8) + 'l';
	public static final int kEventParamDirectObject = ('-'<<24) + ('-'<<16) + ('-'<<8) + '-';
	public static final int kEventParamKeyCode = ('k'<<24) + ('c'<<16) + ('o'<<8) + 'd';
	public static final int kEventParamKeyMacCharCodes = ('k'<<24) + ('c'<<16) + ('h'<<8) + 'r';
	public static final int kEventParamKeyModifiers = ('k'<<24) + ('m'<<16) + ('o'<<8) + 'd';
	public static final int kEventParamMouseButton = ('m'<<24) + ('b'<<16) + ('t'<<8) + 'n';
	public static final int kEventParamMouseChord = ('c'<<24) + ('h'<<16) + ('o'<<8) + 'r';
	public static final int kEventParamMouseLocation = ('m'<<24) + ('l'<<16) + ('o'<<8) + 'c';
	public static final int kEventParamMouseWheelDelta = ('m'<<24) + ('w'<<16) + ('d'<<8) + 'l';
	public static final int kEventParamRgnHandle =  ('r'<<24) + ('g'<<16) + ('n'<<8) + 'h';
	public static final int kEventParamTextInputSendText = ('t'<<24) + ('s'<<16) + ('t'<<8) + 'x';
	public static final int kEventParamWindowDefPart = ('w'<<24) + ('d'<<16) + ('p'<<8) + 'c';
	public static final int kEventParamWindowRef = ('w'<<24) + ('i'<<16) + ('n'<<8) + 'd';
	public static final int kEventProcessCommand = 1;
	public static final int kEventRawKeyDown = 1;
	public static final int kEventRawKeyRepeat = 2;
	public static final int kEventRawKeyUp = 3;
	public static final int kEventRawKeyModifiersChanged = 4;
	public static final int kEventTextInputUnicodeForKeyEvent = 2;
	public static final int kEventWindowActivated = 5;
	public static final int kEventWindowBoundsChanged = 27;
	public static final int kEventWindowClose = 72;
	public static final int kEventWindowDeactivated = 6;
	public static final int kEventWindowDrawContent = 2;
	public static final int kFloatingWindowClass = 5;
	public static final int kHIComboBoxAutoSizeListAttribute = (1 << 3);
	public static final int kHIComboBoxEditTextPart = 5;
	public static final int kHIViewZOrderAbove = 1;
	public static final int kHIViewZOrderBelow = 2;
	public static final int kHelpWindowClass = 10;
	public static final int kInvalidFontFamily = -1;
	public static final int kMenuBlankGlyph = 97;
	public static final int kMenuCapsLockGlyph = 99;
	public static final int kMenuCheckmarkGlyph = 18;
	public static final int kMenuClearGlyph = 28;
	public static final int kMenuCommandGlyph = 17;
	public static final int kMenuContextualMenuGlyph = 109;
	public static final int kMenuControlGlyph = 6;
	public static final int kMenuControlISOGlyph = 138;
	public static final int kMenuControlModifier = 4;
	public static final int kMenuDeleteLeftGlyph = 23;
	public static final int kMenuDeleteRightGlyph = 10;
	public static final int kMenuDiamondGlyph = 19;
	public static final int kMenuDownArrowGlyph = 106;
	public static final int kMenuDownwardArrowDashedGlyph = 16;
	public static final int kMenuEnterGlyph = 4;
	public static final int kMenuEscapeGlyph = 27;
	public static final int kMenuF10Glyph = 120;
	public static final int kMenuF11Glyph = 121;
	public static final int kMenuF12Glyph = 122;
	public static final int kMenuF1Glyph = 111;
	public static final int kMenuF2Glyph = 112;
	public static final int kMenuF3Glyph = 113;
	public static final int kMenuF4Glyph = 114;
	public static final int kMenuF5Glyph = 115;
	public static final int kMenuF6Glyph = 116;
	public static final int kMenuF7Glyph = 117;
	public static final int kMenuF8Glyph = 118;
	public static final int kMenuF9Glyph = 119;
	public static final int kMenuHelpGlyph = 103;
	public static final int kMenuItemAttrSeparator = 64;
	public static final int kMenuLeftArrowDashedGlyph = 24;
	public static final int kMenuLeftArrowGlyph = 100;
	public static final int kMenuNoCommandModifier = (1 << 3);
	public static final int kMenuNoModifiers = 0;
	public static final int kMenuNonmarkingReturnGlyph = 13;
	public static final int kMenuNullGlyph = 0;
	public static final int kMenuOptionGlyph = 7;
	public static final int kMenuOptionModifier = (1 << 1);
	public static final int kMenuPageDownGlyph = 107;
	public static final int kMenuPageUpGlyph = 98;
	public static final int kMenuPencilGlyph = 15;
	public static final int kMenuPowerGlyph = 110;
	public static final int kMenuReturnGlyph = 11;
	public static final int kMenuReturnR2LGlyph = 12;
	public static final int kMenuRightArrowDashedGlyph = 26;
	public static final int kMenuRightArrowGlyph = 101;
	public static final int kMenuShiftGlyph = 5;
	public static final int kMenuShiftModifier = (1 << 0);
	public static final int kMenuTabRightGlyph = 2;
	public static final int kMenuUpArrowDashedGlyph = 25;
	public static final int kMenuUpArrowGlyph = 104;
	public static final int kModalWindowClass = 3;
	public static final int kMovableModalWindowClass = 4;
	public static final int kNavAllowInvisibleFiles = 0x00000100;
	public static final int kNavAllowMultipleFiles = 0x00000080;
	public static final int kNavAllowOpenPackages = 0x00002000;
	public static final int kNavCBNewLocation = 5;
	public static final int kNavSupportPackages = 0x00001000;
	public static final int kNavUserActionCancel = 1;
	public static final int kNavUserActionChoose = 4;
	public static final int kNavUserActionOpen = 2;
	public static final int kNavUserActionSaveAs = 3;
	public static final int kQDUseCGTextMetrics = (1 << 2);
	public static final int kQDUseCGTextRendering = (1 << 1);
	public static final boolean kScrollBarsSyncWithFocus = false;
	public static final int kSheetWindowClass = 11;
	public static final int kTXNAlwaysWrapAtViewEdgeMask = 1 << 11;
	public static final int kTXNDoFontSubstitution = ('f'<<24) + ('s'<<16) + ('u'<<8) + 'b';
	public static final int kTXNDontDrawCaretWhenInactiveMask = 1 << 12;
	public static final int kTXNEndOffset = 2147483647;
	public static final int kTXNMonostyledTextMask = 1 << 17;
	public static final int kTXNReadOnlyMask = 1 << 5;
	public static final int kTXNSingleLineOnlyMask = 1 << 14;
	public static final int kTXNStartOffset = 0;
	public static final int kTXNSystemDefaultEncoding = 0;
	public static final int kTXNTextEditStyleFrameType = 1;
	public static final int kTXNUnicodeTextData = ('u'<<24) + ('t'<<16) + ('x'<<8) + 't';
	public static final int kTXNUnicodeTextFile = ('u'<<24) + ('t'<<16) + ('x'<<8) + 't';
	public static final int kTXNUseCurrentSelection = -1;
	public static final int kTXNVisibilityTag = ('v'<<24) + ('i'<<16) + ('s'<<8) + 'b';
	public static final int kTXNWantHScrollBarMask = 1 << 2;
	public static final int kTXNWantVScrollBarMask = 1 << 3;
	public static final int kThemeArrowCursor = 0;
	public static final int kThemeBrushDialogBackgroundActive = 1;
	public static final int kThemeBrushDocumentWindowBackground = 15;
	public static final int kThemeButtonOff = 0;
	public static final int kThemeButtonOn = 1;
	public static final int kThemeCrossCursor = 5;
	public static final int kThemeCurrentPortFont = 200;
	public static final int kThemeIBeamCursor = 4;
	public static final int kThemeOpenHandCursor = 9;
	public static final int kThemeSmallBevelButton = 8;
	public static final int kThemeSmallEmphasizedSystemFont = 2;
	public static final int kThemeSmallSystemFont = 1;
	public static final int kThemeSpinningCursor = 14;
	public static final int kThemeStateActive = 1;
	public static final int kThemeStatePressed = 2;
	public static final int kThemeSystemFont = 0;
	public static final int kThemeWatchCursor = 7;
	public static final int kTXNMarginsTag = ('m'<<24) + ('a'<<16) + ('r'<<8) + 'g';
	public static final int kUtilityWindowClass = 8;
    public static final int kWindowActivationScopeNone = 0;
    public static final int kWindowActivationScopeIndependent = 1;
    public static final int kWindowActivationScopeAll = 2;
	public static final int kWindowCloseBoxAttribute = (1 << 0);
	public static final int kWindowCollapseBoxAttribute = (1 << 3);
	public static final int kWindowCompositingAttribute = (1 << 19);
	public static final int kWindowContentRgn = 33;
	public static final int kWindowHorizontalZoomAttribute = 1 << 1;
	public static final int kWindowVerticalZoomAttribute  = 1 << 2;
	public static final int kWindowFullZoomAttribute = (OS.kWindowVerticalZoomAttribute | OS.kWindowHorizontalZoomAttribute);
	public static final int kWindowLiveResizeAttribute = (1 << 28);
	public static final int kWindowModalityAppModal = 2;
	public static final int kWindowModalityNone = 0;
	public static final int kWindowModalitySystemModal = 1;
	public static final int kWindowModalityWindowModal = 3;
	public static final int kWindowNoShadowAttribute = (1 << 21);
	public static final int kWindowResizableAttribute = (1 << 4);
	public static final int kWindowStandardHandlerAttribute = (1 << 25);
	public static final int kWindowStructureRgn = 32;
	public static final int mouseDown = 1;
	public static final int noErr = 0;
	public static final int normal = 0;
	public static final int optionKey = 1 << 11;
	public static final int shiftKey = 1 << 9;
	public static final int smSystemScript = -1;
	public static final int srcCopy = 0;
	public static final int srcOr = 1;
	public static final int typeCGContextRef= ('c'<<24) + ('n'<<16) + ('t'<<8) + 'x';
	public static final int typeChar = ('T'<<24) + ('E'<<16) + ('X'<<8) + 'T';
	public static final int typeControlPartCode = ('c'<<24) + ('p'<<16) + ('r'<<8) + 't';
	public static final int typeControlRef = ('c'<<24) + ('t'<<16) + ('r'<<8) + 'l';
	public static final int typeFSRef = ('f'<<24) + ('s'<<16) + ('r'<<8) + 'f';
	public static final int typeHICommand = ('h'<<24) + ('c'<<16) + ('m'<<8) + 'd';
	public static final int typeMouseButton = ('m'<<24) + ('b'<<16) + ('t'<<8) + 'n';
	public static final int typeQDPoint = ('Q'<<24) + ('D'<<16) + ('p'<<8) + 't';
	public static final int typeQDRgnHandle= ('r'<<24) + ('g'<<16) + ('n'<<8) + 'h';
	public static final int typeSInt32 = ('l'<<24) + ('o'<<16) + ('n'<<8) + 'g';
	public static final int typeType = ('t'<<24) + ('y'<<16) + ('p'<<8) + 'e';
	public static final int typeUInt32 = ('m'<<24) + ('a'<<16) + ('g'<<8) + 'n';
	public static final int typeUnicodeText = ('u'<<24) + ('t'<<16) + ('x'<<8) + 't';
	public static final int typeWindowDefPartCode = ('w'<<24) + ('d'<<16) + ('p'<<8) + 't';
	public static final int typeWindowRef = ('w'<<24) + ('i'<<16) + ('n'<<8) + 'd';
	public static final int updateEvt = 6;
	public static final int updateMask = 1 << updateEvt;

/** Natives */
public static final native int kHIViewWindowContentID();
public static final native int AECountItems(AEDesc theAEDescList, int[] theCount);
public static final native int AEGetNthPtr(AEDesc theAEDescList, int index, int desiredType, int[] theAEKeyword, int[] typeCode, int dataPtr, int maximumSize, int[] actualSize);
public static final native int AEProcessAppleEvent(EventRecord theEventRecord);
public static final native int AddDataBrowserItems(int cHandle, int containerID, int numItems, int[] itemIDs, int preSortProperty);
public static final native int AddDataBrowserListViewColumn(int browser, DataBrowserListViewColumnDesc columnDesc, int position);  
public static final native int AppendMenuItemTextWithCFString(int mHandle, int sHandle, int attributes, int commandID, short[] outItemIndex);
public static final native int AutoSizeDataBrowserListViewColumns(int cHandle);
public static final native void BeginUpdate(int wHandle);
public static final native void BringToFront(int wHandle);
public static final native void CFRelease(int sHandle);
public static final native int CFStringCreateWithCharacters(int alloc, char[] chars, int numChars);
public static final native void CFStringGetCharacters(int theString, CFRange range, char[] buffer);
public static final native int CFStringGetLength(int theString);
public static final native int CFURLCopyFileSystemPath(int anURL, int pathStyle);
public static final native int CFURLCreateFromFSRef(int allocator, byte[] fsRef);
public static final native void CGContextScaleCTM(int inContext, float sx, float sy);
public static final native void CGContextTranslateCTM(int inContext, float tx, float ty);
public static final native int CGBitmapContextCreate(int data, int width, int height, int bitsPerComponent, int bytesPerRow, int colorspace, int alphaInfo);
public static final native int CGColorSpaceCreateDeviceRGB ();
public static final native void CGColorSpaceRelease (int cs);
public static final native void CGContextAddArc (int ctx, float x, float y, float radius, float startAngle, float endAngle, boolean clockwise);
public static final native void CGContextAddLineToPoint (int ctx, float x, float y);
public static final native void CGContextAddLines (int ctx, CGPoint points, int count);
public static final native void CGContextBeginPath (int ctx);
public static final native void CGContextClip (int ctx);
public static final native void CGContextClosePath (int ctx);
public static final native void CGContextDrawImage (int ctx, CGRect rect, int image);
public static final native void CGContextFillPath (int ctx);
public static final native void CGContextStrokeRect (int ctx, CGRect rect);
public static final native void CGContextFillRect (int ctx, CGRect rect);
public static final native void CGContextGetTextPosition (int ctx, CGPoint point);
public static final native void CGContextMoveToPoint (int ctx, float x, float y);
public static final native void CGContextRelease(int ctx);
public static final native void CGContextRestoreGState(int ctx);
public static final native void CGContextSaveGState(int ctx);
public static final native void CGContextSelectFont (int ctx, byte[] name, float size, int textEncoding);
public static final native void CGContextSetFillColorSpace (int ctx, int colorspace);
public static final native void CGContextSetFontSize (int ctx, float size);
public static final native void CGContextSetStrokeColorSpace (int ctx, int colorspace);
public static final native void CGContextSetFillColor (int ctx, float[] value);
public static final native void CGContextSetLineDash (int ctx, float phase, float[] lengths, int count);
public static final native void CGContextSetLineWidth (int ctx, float width);
public static final native void CGContextSetStrokeColor (int ctx, float[] value);
public static final native void CGContextSetRGBFillColor (int ctx, float r, float g, float b, float alpha);
public static final native void CGContextSetRGBStrokeColor (int ctx, float r, float g, float b, float alpha);
public static final native void CGContextSetTextDrawingMode (int ctx, int mode);
public static final native void CGContextSetTextPosition (int ctx, float x, float y);
public static final native void CGContextShowText (int ctx, byte[] cstring, int length);
public static final native void CGContextShowTextAtPoint (int ctx, float x, float y, byte[] cstring, int length);
public static final native void CGContextSetTextMatrix (int ctx, float[] transform);
public static final native void CGContextStrokePath (int ctx);
public static final native int CGDataProviderCreateWithData (int info, int data, int size, int releaseData);
public static final native void CGDataProviderRelease (int provider);
public static final native int CGImageCreate (int width, int height, int bitsPerComponent, int bitsPerPixel, int bytesPerRow, int colorspace, int alphaInfo, int provider, float[] decode, boolean shouldInterpolate, int intent);
public static final native int CGImageGetAlphaInfo (int image);
public static final native int CGImageGetBitsPerComponent (int image);
public static final native int CGImageGetBitsPerPixel (int image);
public static final native int CGImageGetBytesPerRow (int image);
public static final native int CGImageGetColorSpace (int image);
public static final native int CGImageGetHeight (int image);
public static final native int CGImageGetWidth (int image);
public static final native void CGImageRelease (int image);
public static final native int CallNextEventHandler(int nextHandler, int eventRefHandle);
public static final native short CharWidth(short c);
public static final native int ClearCurrentScrap();
public static final native int ClipCGContextToRegion(int inContext, Rect portRect, int rgnHandle);
public static final native int CloseDataBrowserContainer(int cHandle, int container);
public static final native void ClosePoly();
public static final native int CollapseWindow(int wHandle, boolean collapse);
public static final native boolean ConvertEventRefToEventRecord(int inEvent, EventRecord outEvent);
public static final native void CopyBits(int srcPixMapHandle, int dstPixMapHandle, Rect srcRect, Rect dstRect, short mode, int maskRgn);
public static final native int CopyControlTitleAsCFString(int cHandle, int[] sHandle);
public static final native void CopyDeepMask(int srcPixMapHandle, int maskPixMapHandle, int dstPixMapHandle, Rect srcRect, Rect maskRect, Rect dstRect, short mode, int maskRgn);
public static final native int CopyMenuItemTextAsCFString(int mHandle, short index, int[] sHandle);
public static final native void CopyRgn(int srcRgnHandle, int dstRgnHandle);
public static final native short CountMenuItems(int mHandle);
public static final native int CountSubControls(int cHandle, short[] count);
public static final native int CreateDataBrowserControl(int window, Rect boundsRect, int style,int[] outControl);
public static final native int CreateEvent(int allocator, int inClassID, int kind, double when, int flags, int[] outEventRef);
public static final native int CreateNewMenu(int menuID, int menuAttributes, int[] menuRef);
public static final native int CreateNewWindow(int windowClass, int attributes, Rect bounds, int[] wHandle);
public static final native int CreatePushButtonControl(int window, Rect boundsRect, int title, int[] outControl);
public static final native int CreateRootControl(int windowHandle, int[] cHandle);
public static final native int CreateStandardAlert(short alertType, int errorSHandle, int explanationSHandle, int alertParamHandle, int[] dialogHandle);
public static final native void DeleteMenu(short menuID);
public static final native void DeleteMenuItem(int mHandle, short index);
public static final native int DeleteMenuItems(int mHandle, short firstItem, int numItems);
public static final native void DiffRgn(int srcRgnA, int srcRgnB, int dstRgn);
public static final native int DisableControl(int cHandle);
public static final native void DisableMenuCommand(int mHandle, int commandId);
public static final native void DisableMenuItem(int mHandle, short index);
public static final native void DisposeControl(int cHandle);
public static final native void DisposeGWorld(int offscreenGWorld);
public static final native void DisposeHandle(int handle);
public static final native void DisposeMenu(int mHandle);
public static final native void DisposePtr(int ptr);
public static final native void DisposeRgn(int rgnHandle);
public static final native void DisposeWindow(int wHandle);
public static final native void DrawMenuBar();
public static final native void DrawText(byte[] textBuf, short firstByte, short byteCount);
public static final native int DrawThemeButton(Rect inBounds, short inKind, ThemeButtonDrawInfo inNewInfo, ThemeButtonDrawInfo inPrevInfo, int inEraseProc, int inLabelProc, int inUserData);
public static final native int DrawThemeEditTextFrame(Rect bounds, int state);
public static final native int DrawThemeFocusRect(Rect bounds, boolean hasFocus);
public static final native int DrawThemeSeparator(Rect bounds, int state);
public static final native int DrawThemeTextBox(int sHandle, short fontID, int state, boolean wrapToWidth, Rect bounds, short just, int context);
public static final native boolean EmptyRect(Rect r);
public static final native boolean EmptyRgn(int rgnHandle);
public static final native int EnableControl(int cHandle);
public static final native void EnableMenuCommand(int mHandle, int commandId);
public static final native void EnableMenuItem(int mHandle, short index);
public static final native void EndUpdate(int wHandle);
public static final native void EraseRect(Rect bounds);
public static final native void EraseRgn(int rgnHandle);
public static final native int FMGetFontFamilyName(short id, byte[] name);
public static final native short FMGetFontFamilyFromName(byte[] name);
public static final native short FindWindow(Point where, int[] wHandle);
public static final native void FrameOval(Rect bounds);
public static final native void FramePoly(int polyHandle);
public static final native void FrameRect(Rect bounds);
public static final native void FrameRoundRect(Rect bounds, short ovalWidth, short ovalHeight);
public static final native int FrontWindow();
public static final native int GetApplicationEventTarget();
public static final native int GetAvailableWindowAttributes(int windowClass);
public static final native int GetAvailableWindowPositioningBounds(int inDevice, Rect outAvailableRect);
public static final native int GetBestControlRect(int inControl, Rect outRect, short[] outBaseLineOffset);
public static final native int GetCaretTime();
public static final native void GetClip(int rgnHandle);
public static final native int GetControl32BitMaximum(int cHandle);
public static final native int GetControl32BitMinimum(int cHandle);
public static final native int GetControl32BitValue(int cHandle);
public static final native void GetControlBounds(int cHandle, Rect bounds);
public static final native int GetControlData(int inControl, short inPart, int inTagName, int inBufferSize, Rect inBuffer, int[] outActualSize);
public static final native int GetControlData(int inControl, short inPart, int inTagName, int inBufferSize, int[] inBuffer, int[] outActualSize);
public static final native int GetControlData(int inControl, short inPart, int inTagName, int inBufferSize, short[] inBuffer, int[] outActualSize);
public static final native int GetControlEventTarget(int cHandle);
public static final native int GetControlOwner(int cHandle);
public static final native int GetControlReference(int cHandle);
public static final native int GetControlRegion(int cHandle, short inPart, int rgnHandle);
public static final native short GetControlValue(int cHandle);
public static final native int GetControlViewSize(int cHandle);
public static final native int GetCurrentEventLoop();
public static final native int GetCurrentProcess(int[] psn);
public static final native int GetCurrentScrap(int[] scrap);
public static final native int GetDataBrowserCallbacks(int browser, DataBrowserCallbacks  callbacks);
public static final native int GetDataBrowserItemCount(int cHandle, int container, boolean recurse, int state, int[] numItems);
public static final native int GetDataBrowserItemPartBounds(int cHandle, int item, int property, int part, Rect bounds);
public static final native int GetDataBrowserItems(int browser, int container, boolean recurse, int state, int items);
public static final native int GetDataBrowserScrollPosition(int cHandle, int[] top, int[] left);
public static final native int GetDblTime();
public static final native int GetEventClass(int eHandle);
public static final native int GetEventDispatcherTarget();
public static final native int GetEventKind(int eHandle);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, int[] outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, char[] outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, short[] outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, byte[] outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, HICommand outData);
public static final native double GetEventTime(int eHandle);
public static final native void GetFontInfo(short[] info);
public static final native int GetGDevice();
public static final native void GetGWorld(int[] portHandle, int[] gdHandle);
public static final native void GetGlobalMouse(Point where);
public static final native int GetHandleSize(int handle);
public static final native int GetIndMenuItemWithCommandID(int mHandle, int commandId, int index, int[] outMenu, short[] outIndex);
public static final native int GetIndexedSubControl(int cHandle, short index, int[] outHandle);
public static final native int GetKeyboardFocus(int wHandle, int[] cHandle);
public static final native double GetLastUserEventTime();
public static final native int GetMainDevice();
public static final native int GetMainEventQueue();
public static final native int GetMenuCommandMark(int mHandle, int commandId, char[] outMark);
public static final native int GetMenuEventTarget(int cHandle);
public static final native int GetMenuFont(int mHandle, short[] fontID, short[] size);
public static final native short GetMenuID(int mHandle);
public static final native int GetMenuItemCommandID(int mHandle, short index, int[] outCommandID);
public static final native int GetMenuItemHierarchicalMenu(int inMenu, short inItem, int []outHierMenu);
public static final native int GetMenuItemRefCon(int mHandle, short index, int[] refCon);
public static final native void GetMouse(Point where);
public static final native void GetPixBounds(int pHandle, Rect bounds);
public static final native short GetPixDepth(int pHandle);
public static final native void GetPort(int[] port);
public static final native int GetPortBitMapForCopyBits(int portHandle);
public static final native void GetPortBounds(int pHandle, Rect rect);
public static final native void GetPortClipRegion(int port, int clipRgn);
public static final native int GetPortVisibleRegion(int portHandle, int rgnHandle);
public static final native int GetPtrSize(int ptr);
public static final native void GetRegionBounds(int rgnHandle, Rect bounds);
public static final native int GetRootControl(int windowHandle, int[] cHandle);
public static final native int GetScrapFlavorCount(int scrap, int[] infoCount);
public static final native int GetScrapFlavorData(int scrap, int flavorType, int[] byteCount, byte[] destination);
public static final native int GetScrapFlavorInfoList(int scrap, int[] infoCount, int[] info);
public static final native int GetScrapFlavorSize(int scrap, int flavorType, int[] byteCount);
public static final native int GetSuperControl(int cHandle, int[] parentHandle);
public static final native int GetThemeDrawingState(int[] state);
public static final native int GetThemeFont(short themeFontId, short scriptCode, byte[] fontName, short[] fontSize, byte[] style);
public static final native int GetThemeTextDimensions(int sHandle, short fontID, int state, boolean wrapToWidth, short[] ioBounds, short[] baseLine);
public static final native int GetUserFocusEventTarget();
public static final native int GetWRefCon(int wHandle);
public static final native void GetWindowBounds(int wHandle, short windowRegion, Rect bounds);
public static final native int GetWindowDefaultButton(int wHandle, int[] cHandle);
public static final native int GetWindowEventTarget(int wHandle);
public static final native int GetWindowFromPort(int pHandle);
public static final native int GetWindowModality(int wHandle, int[] modalityKind, int[] unavailableWindowHandle);
public static final native int GetWindowPort(int wHandle);
public static final native int HIComboBoxAppendTextItem(int inComboBox, int inText, int[] outIndex);
public static final native int HIComboBoxCopyTextItemAtIndex(int inComboBox, int inIndex, int[] outString);
public static final native int HIComboBoxCreate(CGRect boundsRect, int text, ControlFontStyleRec style, int list, int inAttributes, int[] outComboBox);
public static final native int HIComboBoxGetItemCount(int inComboBox);
public static final native int HIComboBoxInsertTextItemAtIndex(int inComboBox, int inIndex, int inText);
public static final native int HIComboBoxRemoveItemAtIndex(int inComboBox, int inIndex);
public static final native int HIObjectCopyClassID(int inObject);
public static final native int HIObjectCreate(int inClassID, int inConstructData, int[] outObject);
public static final native int HIObjectRegisterSubclass(int inClassID, int inBaseClassID, int inOptions, int inConstructProc, int inNumEvents, int[] inEventList, int inConstructData, int[] outClassRef);
public static final native int HIViewAddSubview(int parent, int child);
public static final native int HIViewClick(int inView, int inEvent);
public static final native int HIViewConvertPoint(CGPoint ioPoint, int inSourceView, int inDestView);
public static final native int HIViewFindByID(int inStartView, int inID, int[] outControl);
public static final native int HIViewGetFrame(int inView, CGRect outRect);
public static final native int HIViewGetRoot(int wHandle);
public static final native int HIViewGetViewForMouseEvent(int inView, int inEvent, int[] outView);
public static final native int HIViewRemoveFromSuperview(int inView);
public static final native int HIViewSetDrawingEnabled(int inView, boolean isEnabled);
public static final native int HIViewSetFrame(int inView, CGRect inRect);
public static final native int HIViewSetNeedsDisplay(int inView, boolean inNeedsDisplay);
public static final native int HIViewSetNeedsDisplayInRegion(int inView, int inRgn, boolean inNeedsDisplay);
public static final native int HIViewSetVisible(int inView, boolean inVisible);
public static final native int HIViewSetZOrder(int inView, int inOp, int inOther);
public static final native int HIViewSimulateClick(int inView, short inPartToClick, int modifiers, short[] outPartClicked);
public static final native short HandleControlClick(int cHandle, Point where, int modifiers, int actionUPP);
public static final native short HiWord(int doubleWord);
public static final native void HideWindow(int wHandle);
public static final native void HiliteMenu(short menuID);
public static final native void HLock(int h);
public static final native void HUnlock(int h);
public static final native int InitContextualMenus();
public static final native void InitCursor();
public static final native int InitDataBrowserCallbacks(DataBrowserCallbacks callbacks);
public static final native void InsertMenu(int mHandle, short beforeID);
public static final native int InsertMenuItemTextWithCFString(int mHandle, int sHandle, short index, int attributes, int commandID);
public static final native int InstallEventHandler(int inTarget, int inHandler, int inNumTypes, int[] inList, int inUserData, int[] outRef);
public static final native int InstallEventLoopTimer(int inEventLoop, double inFireDelay, double inInterval, int inTimerProc, int inTimerData, int[] outTimer);
public static final native void InvalWindowRect(int wHandle, Rect bounds);
public static final native void InvalWindowRgn(int wHandle, int rgnHandle);
public static final native void InvertRect(Rect r);
public static final native void InvertRgn(int rgnHandle);
public static final native boolean IsControlActive(int inControl);
public static final native boolean IsControlEnabled(int cHandle);
public static final native boolean IsControlVisible(int cHandle);
public static final native boolean IsDataBrowserItemSelected(int cHandle, int itemID);
public static final native boolean IsMenuCommandEnabled(int mHandle, int commandId);
public static final native boolean IsMenuItemEnabled(int mHandle, short index);
public static final native boolean IsValidControlHandle(int cHandle);
public static final native boolean IsValidMenu(int mHandle);
public static final native boolean IsValidWindowPtr(int grafPort);
public static final native boolean IsWindowActive(int wHandle);
public static final native boolean IsWindowVisible(int wHandle);
public static final native void KillPoly(int polyHandle);
public static final native void LineTo(short h, short v);
public static final native short LoWord(int doubleWord);
public static final native int LockPortBits(int portHandle);
public static final native int MenuSelect(Point mHandle);
public static final native void MoveControl(int theControl, short h, short v);
public static final native void MoveTo(short h, short v);
public static final native void MoveWindow(int wHandle, short h, short v, boolean toFront);
public static final native int NavCreateChooseFolderDialog(NavDialogCreationOptions inOptions, int inEventProc, int inFilterProc, int inClientData, int[] outDialog);
public static final native int NavCreateGetFileDialog(NavDialogCreationOptions inOptions, int inTypeList, int inEventProc, int inPreviewProc, int inFilterProc, int inClientData, int[] outDialog);
public static final native int NavCreatePutFileDialog(NavDialogCreationOptions inOptions, int inFileType, int inFileCreator, int inEventProc, int inClientData, int[] outDialog);
public static final native void NavDialogDispose(int dialogHandle);
public static final native int NavDialogGetSaveFileName(int dialogHandle);
public static final native int NavDialogGetUserAction(int dialogHandle);
public static final native int NavDialogRun(int dialogHandle);
public static final native int NavDialogSetSaveFileName(int dialogHandle, int fileNameHandle);
public static final native int NavGetDefaultDialogCreationOptions(NavDialogCreationOptions outOptions);
public static final native int NavDialogGetReply(int inDialog, NavReplyRecord outReply);
public static final native int NewControl(int owningWindow, Rect boundsRect, byte[] controlTitle, boolean initiallyVisible, short initialValue, short minimumValue, short maximumValue, short procID, int controlReference);
public static final native int NewGWorldFromPtr(int[] offscreenGWorld, int PixelFormat, Rect boundsRect, int cTable, int aGDevice, int flags, int newBuffer, int rowBytes);
public static final native int NewHandle(int size);
public static final native int NewHandleClear(int size);
public static final native int NewPtr(int size);
public static final native int NewPtrClear(int size);
public static final native int NewRgn();
public static final native void OffsetRgn(int rgnHandle, short dh, short dv);
public static final native int OpenDataBrowserContainer(int cHandle, int container);
public static final native int OpenPoly();
public static final native void PaintOval(Rect bounds);
public static final native void PaintPoly(int polyHandle);
public static final native void PaintRect(Rect bounds);
public static final native void PaintRoundRect(Rect bounds, short ovalWidth, short ovalHeight);
public static final native void PenSize(short h, short v);
public static final native int PickColor(ColorPickerInfo theColorInfo);
public static final native int PopUpMenuSelect(int mHandle, short top, short left, short popUpItem);
public static final native int PostEvent(short eventNum, int eventMsg);
public static final native int PostEventToQueue(int inQueue, int inEvent, short inPriority);
public static final native boolean PtInRect(Point pt, Rect r);
public static final native boolean PtInRgn(Point pt, int rgnHandle);
public static final native int PutScrapFlavor(int scrap, int flavorType, int flavorFlags, int flavorSize, byte[] flavorData);
public static final native int QDBeginCGContext(int inPort, int[] outContext);
public static final native int QDEndCGContext(int inPort, int[] inoutContext);
public static final native void QDFlushPortBuffer(int port, int rgnHandle);
public static final native void QDGlobalToLocalPoint(int port, Point point);
public static final native void QDLocalToGlobalPoint(int port, Point point);
public static final native void QDSetPatternOrigin(Point point);
public static final native int QDSwapTextFlags(int flags);
public static final native void RGBBackColor(RGBColor color);
public static final native void RGBForeColor(RGBColor color);
public static final native int ReceiveNextEvent(int inNumTypes, int[] inList, double inTimeout, boolean inPullEvent, int[] outEvent);
public static final native boolean RectInRgn(Rect rect, int rgnHandle);
public static final native void RectRgn(int rgnHandle, Rect left);
public static final native int RegisterAppearanceClient();
public static final native void ReleaseEvent(int theEvent);
public static final native int ReleaseMenu(int mHandle);
public static final native int RemoveDataBrowserItems(int cHandle, int containerID, int numItems, int[] itemIDs, int preSortProperty);
public static final native int RemoveEventLoopTimer(int inTimer);
public static final native int RetainMenu(int mHandle);
public static final native int RevealDataBrowserItem(int cHandle, int itemID, int colID, boolean center);
public static final native int RunStandardAlert(int dialogHandle, int modalFilterUPP, short[] itemHit);
public static final native void ScrollRect(Rect rect, short dh, short dv, int updateRgn);
public static final native void SectRgn(int srcRgnA, int srcRgnB, int dstRgn);
public static final native void SelectWindow(int wHandle);
public static final native int SendEventToEventTarget(int theEvent, int theTarget);
public static final native int SetBevelButtonContentInfo(int inButton, ControlButtonContentInfo inContent);
public static final native void SetClip(int rgnHandle);
public static final native void SetControl32BitMaximum(int cHandle, int maximum);
public static final native void SetControl32BitMinimum(int cHandle, int minimum);
public static final native void SetControl32BitValue(int cHandle, int value);
public static final native void SetControlAction(int cHandle, int actionProc);
public static final native void SetControlBounds(int cHandle, Rect bounds);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, ControlTabInfoRecV1 inData);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, Rect inData);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, short[] inData);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, int[] inData);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, int inData);
public static final native int SetControlFontStyle(int inControl, ControlFontStyleRec inStyle);
public static final native void SetControlPopupMenuHandle(int cHandle, int popupMenuHandle);
public static final native void SetControlReference(int cHandle, int data);
public static final native int SetControlTitleWithCFString(int cHandle, int sHandle);
public static final native void SetControlViewSize(int cHandle, int viewSize);
public static final native void SetCursor(int cursor);
public static final native int SetDataBrowserCallbacks(int browser, DataBrowserCallbacks  callbacks);
public static final native int SetDataBrowserHasScrollBars(int cHandle, boolean hScroll, boolean vScroll);
public static final native int SetDataBrowserItemDataBooleanValue(int itemRef, boolean data);
public static final native int SetDataBrowserItemDataButtonValue(int itemRef, short themeButtonValue);
public static final native int SetDataBrowserItemDataIcon(int itemRef, int iconRef);
public static final native int SetDataBrowserItemDataItemID(int itemRef, int itemID);
public static final native int SetDataBrowserItemDataText(int itemRef, int sHandle);
public static final native int SetDataBrowserListViewDisclosureColumn(int cHandle, int colID, boolean b);
public static final native int SetDataBrowserListViewHeaderBtnHeight(int cHandle, short height);
public static final native int SetDataBrowserScrollPosition(int cHandle, int top, int left);
public static final native int SetDataBrowserSelectedItems(int cHandle, int numItems, int[] items, int operation);
public static final native int SetDataBrowserSelectionFlags(int cHandle, int selectionFlags);
public static final native int SetDataBrowserTarget(int cHandle, int rootID);
public static final native int SetEventParameter(int inEvent, int inName, int inType, int inSize, char[] inDataPtr);
public static final native int SetFrontProcess(int[] psn);
public static final native void SetGWorld(int portHandle, int gdHandle);
public static final native int SetKeyboardFocus(int wHandle, int cHandle, short inPart);
public static final native int SetMenuCommandMark(int mHandle, int commandId, char mark);
public static final native int SetMenuFont(int mHandle, short fontID, short size);
public static final native int SetMenuItemCommandKey(int mHandle, short index, boolean virtualKey, char key);
public static final native int SetMenuItemHierarchicalMenu(int mHandle, short index, int hierMenuHandle);
public static final native int SetMenuItemIconHandle(int mHandle, short item, byte iconType, int iconHandle);
public static final native int SetMenuItemKeyGlyph(int mHandle, short index, short glyph);
public static final native int SetMenuItemModifiers(int mHandle, short index, byte modifiers);
public static final native int SetMenuItemRefCon(int mHandle, short index, int refCon);
public static final native int SetMenuItemTextWithCFString(int mHandle, short index, int sHandle);
public static final native int SetMenuTitleWithCFString(int mHandle, int sHandle);
public static final native void SetOrigin(short h, short v);
public static final native void SetPort(int pHandle);
public static final native void SetPortWindowPort(int wHandle);
public static final native void SetPt(Point p, short h, short v);
public static final native void SetRect(Rect r, short left, short top, short right, short bottom);
public static final native void SetRectRgn(int rgnHandle, short left, short top, short right, short bottom);
public static final native int SetRootMenu(int mHandle);
public static final native int SetThemeBackground(short inBrush, short depth, boolean isColorDevice);
public static final native int SetThemeCursor(int themeCursor);
public static final native int SetThemeDrawingState(int state, boolean disposeNow);
public static final native int SetThemeWindowBackground(int wHandle, short brush, boolean update);
public static final native int SetUpControlBackground(int cHandle, short depth, boolean isColorDevice);
public static final native void SetWRefCon(int wHandle, int data);
public static final native int SetWindowActivationScope(int wHandle, int scope);
public static final native int SetWindowDefaultButton(int wHandle, int cHandle);
public static final native int SetWindowModality(int wHandle, int modalityKind, int unavailableWindowHandle);
public static final native int SetWindowTitleWithCFString(int wHandle, int sHandle);
public static final native void ShowWindow(int wHandle);
public static final native void SizeControl(int cHandle, short w, short h);
public static final native void SizeWindow(int wHandle, short w, short h, boolean update);
public static final native boolean StillDown();
public static final native void SysBeep(short duration);
public static final native int TXNActivate(int txHandle, int frameID, boolean scrollBarState);
public static final native void TXNClick(int iTXNObject, EventRecord iEvent);
public static final native int TXNCopy(int txHandle);
public static final native int TXNCut(int txHandle);
public static final native int TXNDataSize(int txHandle);
public static final native void TXNDeleteObject(int txHandle);
public static final native void TXNDraw(int txHandle, int gDevice);
public static final native int TXNEchoMode(int txHandle, char echoCharacter, int encoding, boolean on);
public static final native void TXNFocus(int txHandle, boolean becomingFocused);
public static final native int TXNGetData(int txHandle, int startOffset, int endOffset, int[] dataHandle);
public static final native int TXNGetLineCount(int txHandle, int[] lineTotal);
public static final native int TXNGetRectBounds(int iTXNObject, Rect oViewRect, TXNLongRect oDestinationRect, TXNLongRect oTextRect);
public static final native void TXNGetSelection(int txHandle, int[] startOffset, int[] endOffset);
public static final native int TXNInitTextension(int iDefaultFonts, int iCountDefaultFonts, int iUsageFlags);
public static final native int TXNNewObject(int fileSpec, int wHandle, Rect bounds, int frameOptions, int frameType, int fileType, int iPermanentEncoding, int[] handle, int[] frameID, int refcon);
public static final native int TXNOffsetToPoint(int txHandle, int offset, Point point);
public static final native int TXNPaste(int txHandle);
public static final native void TXNSelectAll(int txHandle);
public static final native int TXNSetData(int iTXNObject, int iDataType, char[] iDataPtr, int iDataSize, int iStartOffset, int iEndOffset);
public static final native void TXNSetFrameBounds(int txHandle, int top, int left, int bottom, int right, int frameID);
public static final native int TXNSetSelection(int txHandle, int startOffset, int endOffset);
public static final native int TXNSetTXNObjectControls(int iTXNObject, boolean iClearAll, int iControlCount, int[] iControlTags, int[] iControlData);
public static final native void TXNShowSelection(int txHandle, boolean showEnd);
public static final native short TestControl(int control, Point point);
public static final native void TextFace(short face);
public static final native void TextFont(short fontID);
public static final native void TextMode(short mode);
public static final native void TextSize(short size);
public static final native short TextWidth(byte[] textBuf, short firstByte, short byteCount);
public static final native int TrackMouseLocation(int portHandle, Point outPt, short[] outResult);
public static final native void UnionRgn(int srcRgnA, int srcRgnB, int dstRgn);
public static final native int UnlockPortBits(int portHandle);
public static final native void UpdateControls(int wHandle, int rgnHandle);
public static final native int UpdateDataBrowserItems(int cHandle, int container, int numItems, int[] items, int preSortProperty, int propertyID);
public static final native void memcpy(byte[] dest, int src, int n);
public static final native void memcpy(char[] dest, int src, int n);
public static final native void memcpy(int[] dest, int src, int n);
public static final native void memcpy(int dest, int src, int n);
public static final native void memcpy(int dest, byte[] src, int n);
public static final native void memcpy(int dest, Rect src, int n);
public static final native void memset(int dest, int value, int size);

}
